/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.memory.ProbeNotifier;
import org.glassfish.grizzly.memory.ThreadLocalPool;
import org.glassfish.grizzly.memory.ThreadLocalPoolProvider;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;

public abstract class AbstractMemoryManager<E extends Buffer>
implements MemoryManager<E>,
ThreadLocalPoolProvider {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 65536;
    protected final DefaultMonitoringConfig<MemoryProbe> monitoringConfig = new DefaultMonitoringConfig<MemoryProbe>(MemoryProbe.class){

        @Override
        public Object createManagementObject() {
            return AbstractMemoryManager.this.createJmxManagementObject();
        }
    };
    protected final int maxBufferSize;

    public AbstractMemoryManager() {
        this(65536);
    }

    public AbstractMemoryManager(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public int getReadyThreadBufferSize() {
        ThreadLocalPool threadLocalPool = AbstractMemoryManager.getThreadLocalPool();
        if (threadLocalPool != null) {
            return threadLocalPool.remaining();
        }
        return 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    protected Object allocateFromPool(ThreadLocalPool threadLocalCache, int size2) {
        if (threadLocalCache.remaining() >= size2) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, size2);
            return threadLocalCache.allocate(size2);
        }
        return null;
    }

    protected abstract Object createJmxManagementObject();

    protected static ThreadLocalPool getThreadLocalPool() {
        Thread t = Thread.currentThread();
        if (t instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)t).getMemoryPool();
        }
        return null;
    }

    protected static interface TrimAware
    extends Cacheable {
    }
}

